
//--------------
// un-tweaks
//--------------
   matrix World:World;
   matrix WorldVP:WorldViewProjection;
   matrix ViewProj:ViewProjection; 
   float4 BonePalette[240]:JGS;

//--------------
// tweaks
//--------------
   float3 Ambient={0.15f,0.15f,0.15f};
   float3 LightDir={0.5f,-0.5f,0.5f};
   float3 LightColor={0.85f,0.85f,0.85f};
   float3 BacklightColor={0.15f,0.15f,0.15f};

//--------------
// Textures
//--------------
   texture BaseTX <string Name="";>;	
   sampler2D Base = sampler_state 
    {
 	texture = <BaseTX>;
	mipfilter = anisotropic;
	minfilter = anisotropic;
	magfilter = anisotropic;
    };

//--------------
// structs 
//--------------
   struct inputA
     {
 	float4 Pos:POSITION;
	float3 Normal:NORMAL;
 	float2 UV:TEXCOORD0; 
 	float BoneIndex:TEXCOORD1; 
     };
   struct inputB
     {
 	float4 Pos:POSITION;
	float3 Normal:NORMAL;
 	float2 UV:TEXCOORD0; 
 	float2 BoneIndices:TEXCOORD1; 
 	float2 BoneWeights:TEXCOORD2; 
     };

   struct inputC
     {
 	float4 Pos:POSITION;
	float3 Normal:NORMAL;
 	float2 UV:TEXCOORD0; 
 	float3 BoneIndices:TEXCOORD1; 
 	float3 BoneWeights:TEXCOORD2; 
     };

   struct inputD
     {
 	float4 Pos:POSITION;
	float3 Normal:NORMAL;
 	float2 UV:TEXCOORD0; 
 	float4 BoneIndices:TEXCOORD1; 
 	float4 BoneWeights:TEXCOORD2; 
     };






   struct output
     {
	float4 OPos:POSITION; 
	float3 WNormal:TEXCOORD0;
 	float2 Tex:TEXCOORD1; 
     };







//--------------
// vertex shader
//--------------
   output VSA(inputA IN) 
     {
 	output OUT;
	int index = IN.BoneIndex*3;
	matrix model = float4x4(BonePalette[index], BonePalette[index+1], BonePalette[index+2], 0.0,0.0,0.0,1.0);
    	OUT.WNormal=normalize(mul(mul((float3x3)model, IN.Normal),World));
	OUT.OPos=mul(float4(mul(model,IN.Pos).xyz,1.0),WorldVP); 
 	OUT.Tex=IN.UV;
	return OUT;
     }


   output VSB(inputB IN) 
     {
 	output OUT;
    	float3 netPosition=0, netNormal=0;
	int index; 
	float weight;
	float3x4 model;
    	for (int i = 0; i < 2; i++)
    	{
     	  index = IN.BoneIndices[i]*3;
	  weight = IN.BoneWeights[i];
     	  model = float3x4(BonePalette[index], BonePalette[index+1], BonePalette[index+2]);
     	  netPosition += (mul(model,IN.Pos).xyz * weight);
     	  netNormal += (mul((float3x3)model, IN.Normal) * weight);
	}
    	OUT.WNormal=normalize(mul(netNormal,World));
	OUT.OPos=mul(float4(netPosition,1.0),WorldVP); 
 	OUT.Tex=IN.UV;
	return OUT;
     }

   output VSC(inputC IN) 
     {
 	output OUT;
    	float3 netPosition=0, netNormal=0;
	int index; 
	float weight;
	float3x4 model;
    	for (int i = 0; i < 3; i++)
    	{
     	  index = IN.BoneIndices[i]*3;
	  weight = IN.BoneWeights[i];
     	  model = float3x4(BonePalette[index], BonePalette[index+1], BonePalette[index+2]);
     	  netPosition += (mul(model,IN.Pos).xyz * weight);
     	  netNormal += (mul((float3x3)model, IN.Normal) * weight);
	}
    	OUT.WNormal=normalize(mul(netNormal,World));
	OUT.OPos=mul(float4(netPosition,1.0),WorldVP); 
 	OUT.Tex=IN.UV;
	return OUT;
     }

   output VSD(inputD IN) 
     {
 	output OUT;
    	float3 netPosition=0, netNormal=0;
	int index; 
	float weight;
	float3x4 model;
    	for (int i = 0; i < 4; i++)
    	{
     	  index = IN.BoneIndices[i]*3;
	  weight = IN.BoneWeights[i];
     	  model = float3x4(BonePalette[index], BonePalette[index+1], BonePalette[index+2]);
     	  netPosition += (mul(model,IN.Pos).xyz * weight);
     	  netNormal += (mul((float3x3)model, IN.Normal) * weight);
	}
    	OUT.WNormal=normalize(mul(netNormal,World));
	OUT.OPos=mul(float4(netPosition,1.0),WorldVP); 
 	OUT.Tex=IN.UV;
	return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS(output IN)  : COLOR
     {
	float4 Texture=tex2D(Base,IN.Tex); 
	float3 Light=LightColor*saturate(dot(IN.WNormal,normalize(-LightDir)));
	float3 BackLight=BacklightColor*saturate(dot(IN.WNormal,normalize(LightDir))+0.13);
	return Texture*float4(Light+BackLight+Ambient,1.0f);
     }



    float4 PS_BF(output IN)  : COLOR
     {
	return float4(1.0,1.0,1.0, 0.2);
     }

    float4 PS_FF(output IN)  : COLOR
     {
	return float4((IN.WNormal+1)*0.5, 0.4);
     }

    float4 PS_WF(output IN)  : COLOR
     {
	return float4(0.0,0.0,0.0, 1.0);
     }




//--------------
// techniques   
//--------------
   technique Diffuse1
   {
      pass p1
      {		
         vertexShader = compile vs_2_0 VSA(); 
         pixelShader  = compile ps_2_0 PS();
      }
   }


   technique Diffuse2
   {
      pass p1
      {		
         vertexShader = compile vs_2_0 VSB(); 
         pixelShader  = compile ps_2_0 PS();
      }
   }

   technique Diffuse3
   {
      pass p1
      {		
         vertexShader = compile vs_2_0 VSC(); 
         pixelShader  = compile ps_2_0 PS();
      }
   }

   technique Diffuse4
   {
      pass p1
      {		
         vertexShader = compile vs_2_0 VSD(); 
         pixelShader  = compile ps_2_0 PS();
      }
   }











   technique WireFrame1
      {
 	pass p1
      {		
         vertexShader = compile vs_2_0 VSA(); 
 	pixelShader  = compile ps_2_0 PS_BF();
	AlphaBlendEnable= TRUE;
	SrcBlend = SRCALPHA;
	DestBlend = INVSRCALPHA;
	zwriteenable=false;
	BlendOp = Add;
	CullMode = cw;
      }
 	pass p2
      {		
         vertexShader = compile vs_2_0 VSA(); 
 	pixelShader  = compile ps_2_0 PS_FF();
	AlphaBlendEnable= TRUE;
	zwriteenable=false;
	CullMode = ccw;
      }
 	pass p3
      {		
         vertexShader = compile vs_2_0 VSA(); 
 	pixelShader  = compile ps_2_0 PS_WF();
	FillMode = WIREFRAME;
	CullMode = ccw;
      }

      }



   technique WireFrame2
      {
 	pass p1
      {		
         vertexShader = compile vs_2_0 VSB(); 
 	pixelShader  = compile ps_2_0 PS_BF();
	AlphaBlendEnable= TRUE;
	SrcBlend = SRCALPHA;
	DestBlend = INVSRCALPHA;
	zwriteenable=false;
	BlendOp = Add;
	CullMode = cw;
      }
 	pass p2
      {		
         vertexShader = compile vs_2_0 VSB(); 
 	pixelShader  = compile ps_2_0 PS_FF();
	AlphaBlendEnable= TRUE;
	zwriteenable=false;
	CullMode = ccw;
      }
 	pass p3
      {		
         vertexShader = compile vs_2_0 VSB(); 
 	pixelShader  = compile ps_2_0 PS_WF();
	FillMode = WIREFRAME;
	CullMode = ccw;
      }

      }



   technique WireFrame3
      {
 	pass p1
      {		
         vertexShader = compile vs_2_0 VSC(); 
 	pixelShader  = compile ps_2_0 PS_BF();
	AlphaBlendEnable= TRUE;
	SrcBlend = SRCALPHA;
	DestBlend = INVSRCALPHA;
	zwriteenable=false;
	BlendOp = Add;
	CullMode = cw;
      }
 	pass p2
      {		
         vertexShader = compile vs_2_0 VSC(); 
 	pixelShader  = compile ps_2_0 PS_FF();
	AlphaBlendEnable= TRUE;
	zwriteenable=false;
	CullMode = ccw;
      }
 	pass p3
      {		
         vertexShader = compile vs_2_0 VSC(); 
 	pixelShader  = compile ps_2_0 PS_WF();
	FillMode = WIREFRAME;
	CullMode = ccw;
      }

      }

   technique WireFrame4
      {
 	pass p1
      {		
         vertexShader = compile vs_2_0 VSD(); 
 	pixelShader  = compile ps_2_0 PS_BF();
	AlphaBlendEnable= TRUE;
	SrcBlend = SRCALPHA;
	DestBlend = INVSRCALPHA;
	zwriteenable=false;
	BlendOp = Add;
	CullMode = cw;
      }
 	pass p2
      {		
         vertexShader = compile vs_2_0 VSD(); 
 	pixelShader  = compile ps_2_0 PS_FF();
	AlphaBlendEnable= TRUE;
	zwriteenable=false;
	CullMode = ccw;
      }
 	pass p3
      {		
         vertexShader = compile vs_2_0 VSD(); 
 	pixelShader  = compile ps_2_0 PS_WF();
	FillMode = WIREFRAME;
	CullMode = ccw;
      }

      }